<h4 class="text-center" style="font-weight: bold;">Data Diri Siswa</h4>
<hr class="">
<div class="row">
  <div class="col-md-4 form-group">
    <label>Nama</label>
    <input type="text" name="name" value="{{ old('name', $siswa->user->name) }}" class="form-control" 
    placeholder="Tulis dengan huruf kapital sesuai dengan ijasah SD" required>
  </div>
  <div class="col-md-4 form-group">
    <label>NISN</label>
    <input type="text" name="nisn" value="{{ old('nisn', $siswa->nisn) }}" class="form-control" placeholder="(Tuliskan NISN dengan akurat 10 angka)" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Email</label>
    <input type="email" name="email" value="{{ old('email', $siswa->user->email) }}" class="form-control" placeholder="abcd@gmail.com" required>
  </div>
  
  <div class="col-md-4 form-group">
    <label>Jenis Kelamin</label>
    <select name="jenis_kelamin" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      <option value="L" {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'L' ? 'selected' : '' }}>Laki-laki</option>
      <option value="P" {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'P' ? 'selected' : '' }}>Perempuan</option>
    </select>
  </div>

  <div class="col-md-4 form-group">
    <label>Tempat Lahir</label>
    <input type="text" name="tempat_lahir" value="{{ old('tempat_lahir', $siswa->tempat_lahir) }}" class="form-control" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Tanggal Lahir</label>
    <input type="date" name="tanggal_lahir" value="{{ old('tanggal_lahir', $siswa->tanggal_lahir) }}" class="form-control" required>
  </div>

  <div class="col-md-4 form-group">
    <label>No HP</label>
    <input type="text" name="no_hp" value="{{ old('no_hp', $siswa->no_hp) }}" class="form-control" placeholder="(tulis dengan format +62xxxxxxxxxx)" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Sekolah Asal</label>
    <input type="text" name="sekolah_asal" value="{{ old('sekolah_asal', $siswa->sekolah_asal) }}" class="form-control" placeholder="(Sekolah Dasar)" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Agama</label>
    <select name="agama" class="form-control text-dark" required>
      @foreach(['islam','kristen','katolik','hindu','buddha','konghucu','lainnya'] as $a)
        <option value="{{ $a }}" {{ old('agama', $siswa->agama) == $a ? 'selected' : '' }}>{{ ucfirst($a) }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Alamat</label>
    <input type="text" name="alamat" value="{{ old('alamat', $siswa->alamat) }}" class="form-control" required>
  </div>
  <div class="col-md-6 form-group">
    <label>Tempat Tinggal</label>
    <select name="tempat_tinggal" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Bersama Ortu','Ikut Wali','Kos','Asrama','Panti Asuhan','Lainnya'] as $tt)
        <option value="{{ $tt }}" {{ old('tempat_tinggal', $siswa->tempat_tinggal) == $tt ? 'selected' : '' }}>{{ ucfirst($tt) }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-4 form-group">
    <label>NIK</label>
    <input type="text" name="nik" value="{{ old('nik', $siswa->nik) }}" class="form-control" required>
  </div>
  <div class="col-md-4 form-group">
    <label>No KK</label>
    <input type="text" name="no_kk" value="{{ old('no_kk', $siswa->no_kk) }}" class="form-control" required>
  </div>
  <div class="col-md-4 form-group">
    <label>No Registrasi Akte</label>
    <input type="text" name="no_reg_akta" value="{{ old('no_reg_akta', $siswa->no_reg_akta) }}" class="form-control" required>
  </div>

  <div class="col-md-6 form-group">
    <label>Kewarganegaraan</label>
    <select name="kewarganegaraan" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Indonesia (WNI)','Asing (WNA)'] as $k)
        <option value="{{ $k }}" {{ old('kewarganegaraan', $siswa->kewarganegaraan) == $k ? 'selected' : '' }}>{{ ucfirst($k) }}</option>
      @endforeach
    </select>
  </div>
  <div class="col-md-6 form-group">
    <label>Berkebutuhan Khusus</label>
    <select name="berkebutuhan_khusus" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Tidak','Netra','Rungu','Grahita Ringan','Grahita Sedang','Daksa Ringan','Daksa Sedang','Laras','Wicara','Tuna Ganda','Hiper Aktif','Cerdas Istimewa','Bakat Istimewa','Kesulitan Belajar','Narkoba','Indigo','Down Sindrome','Autis'] as $b)
        <option value="{{ $b }}" {{ old('berkebutuhan_khusus', $siswa->berkebutuhan_khusus) == $b ? 'selected' : '' }}>{{ ucfirst($b) }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
  <label>Anak Keberapa</label>
  <input type="number"
         name="anak_ke"
         value="{{ old('anak_ke', $siswa->anak_ke) }}"
         class="form-control"
         inputmode="numeric"
         pattern="[0-9]*"
         required>
</div>

<div class="col-md-6 form-group">
  <label>Jumlah Saudara Kandung</label>
  <input type="number"
         name="jumlah_saudara_kandung"
         value="{{ old('jumlah_saudara_kandung', $siswa->jumlah_saudara_kandung) }}"
         class="form-control"
         inputmode="numeric"
         pattern="[0-9]*"
         required>
</div>

<div class="col-md-12 form-group">
  <label>Jenis Kesejahteraan</label>
  @php
      // 1) Definisikan opsi di sini
      $options = ['PKH','PIP','Kartu Perlindungan Sosial','Kartu Keluarga Sejahtera','Kartu Kesehatan'];

      // 2) Ambil old value atau dari model
      $oldValue = old('jenis_kesejahteraan', $siswa->jenis_kesejahteraan ?? []);
      if (!is_array($oldValue)) {
          $oldValue = json_decode($oldValue, true) ?: [];
      }
  @endphp

  @foreach($options as $jk)
    <div class="form-check">
        <input class="form-check-input ml-1"
               type="checkbox"
               name="jenis_kesejahteraan[]"
               id="jk_{{ Str::slug($jk) }}"
               value="{{ $jk }}"
               {{ in_array($jk, $oldValue) ? 'checked' : '' }}>
        <label class="form-check-label" for="jk_{{ Str::slug($jk) }}">{{ $jk }}</label>
    </div>
  @endforeach
</div>


</div>
