<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LayananParenting extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'layanans';

    protected $primaryKey = 'id';

    protected $fillable = [
        'siswa_id',
        'guru_id',
        'tanggal',
        'tipe',
        'permasalahan',
        'penyelesaian',
        'hasil',
    ];

     protected $dates = ['deleted_at'];

    public function siswa()
    {
        return $this->belongsTo(User::class, 'siswa_id', 'id')->withTrashed();
    }

    public function guru()
    {
        return $this->belongsTo(User::class, 'guru_id', 'id');
    }

    public function getTipeLabelAttribute()
    {
        return $this->tipe ? 'Parenting' : 'Konseling';
    }
}
