<?php

namespace App\Exports;

use App\Models\Guru;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GuruExport implements FromCollection, WithHeadings
{
    public function collection()
    {
        return Guru::with('user')->get()->map(function ($guru) {
            return [
                'nama' => $guru->user->name ?? '-',
                'email' => $guru->user->email ?? '-',
                'nip' => $guru->nip,
                'jenis_kelamin' => $guru->jenis_kelamin,
                'no_hp' => $guru->no_hp,
                'role' => $guru->user->role
            ];
        });
    }

    public function headings(): array
    {
        return [
            'nama',
            'email',
            'nip',
            'jenis_kelamin',
            'no_hp',
            'role'
        ];
    }
}
