<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


class Siswa extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'siswa';

     protected $fillable = [
        'siswa_id',
        'nisn',
        'alamat',
        'tempat_lahir',
        'tanggal_lahir',
        'jenis_kelamin',
        'agama',
        'no_hp',
        'sekolah_asal',
        'lintang',
        'bujur',
        'jenis_tinggal',
        'berkebutuhan_khusus',
        'anak_ke',
        'jumlah_saudara_kandung',
        'nipd',
        'alat_transportasi',
        'no_telepon',
        'rombel_saat_ini',
        'jarak_rumah',
        'alamat_lengkap',
        'dokumen_identitas',
        'data_ayah',
        'data_ibu',
        'data_wali',
        'data_fisik',
        'bantuan_sosial',
        'data_rekening',
        'data_berubah',
        'deskripsi',
    ];

     protected $casts = [
            'data_ayah' => 'array',
            'data_ibu' => 'array',
            'data_wali' => 'array',
            'data_fisik' => 'array',
            'bantuan_sosial' => 'array',
            'data_rekening' => 'array',
            'dokumen_identitas' => 'array',
            'alamat_lengkap' => 'array',
        ];

    protected $dates = ['deleted_at'];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'siswa_id', 'id')->withTrashed();
    }

    public function siswaKelas()
    {
        return $this->hasMany(\App\Models\SiswaKelas::class, 'siswa_id', 'siswa_id');
    }

    public function kelas()
    {
        return $this->hasOneThrough(
            \App\Models\Kelas::class,
            \App\Models\SiswaKelas::class,
            'siswa_id',
            'id',
            'siswa_id',
            'kelas_id'
        )->latest('tahun_ajaran_id');
    }

}
