<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LayananKonseling extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'layanans_konseling';

    protected $fillable = [
        'jadwal_layanan_id', 'siswa_id', 'tipe', 'keterangan', 'tanggal', 'status',
    ];

    protected $dates = ['deleted_at'];

    public function jadwal()
    {
        return $this->belongsTo(JadwalLayanan::class, 'jadwal_layanan_id');
    }

    public function siswa()
    {
        return $this->belongsTo(Siswa::class, 'siswa_id', 'siswa_id')->with('user');
    }
}
