<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BulanKehadiran extends Model
{
    use SoftDeletes;

    protected $table = 'bulan_kehadiran';
    protected $fillable = ['guru_id', 'kelas_id', 'bulan'];

    public function guru(): BelongsTo
    {
        return $this->belongsTo(User::class, 'guru_id');
    }

    public function kelas(): BelongsTo
    {
        return $this->belongsTo(Kelas::class, 'kelas_id');
    }

    public function kehadiranSiswa(): HasMany
    {
        return $this->hasMany(KehadiranSiswa::class, 'bulan_kehadiran_id');
    }
}
    