<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title><?php echo $__env->yieldContent('title', 'Silakan Kepsek'); ?></title>

  <!-- Plugin CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('backend/vendors/feather/feather.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('backend/vendors/ti-icons/css/themify-icons.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('backend/vendors/css/vendor.bundle.base.css')); ?>">

  <!-- Page Plugin CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('backend/vendors/datatables.net-bs4/dataTables.bootstrap4.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('backend/vendors/mdi/css/materialdesignicons.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('backend/js/select.dataTables.min.css')); ?>">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

  <!-- Injected CSS -->
  <link rel="stylesheet" href="<?php echo e(asset('backend/css/vertical-layout-light/style.css')); ?>">

  <!-- Select2 CSS (can be overridden by child views) -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />


  <?php echo $__env->yieldPushContent('styles'); ?>

  <link rel="shortcut icon" href="<?php echo e(asset('backend/images/favicon.png')); ?>" />
</head>

<body>
    <!-- partial:partials/_navbar.html -->
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="#"><span class="text-danger" style="font-size: large; font-weight: bold;">SMPN 6 PEKALONGAN</span></a>
        <a class="navbar-brand brand-logo-mini" href="#"><span class="text-danger" style="font-size: medium; font-weight: bold;">SMP 6</span></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="icon-menu"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item nav-profile dropdown">
            <button type="button" class="btn btn-primary btn-sm w-100 mr-3">
              <a href="<?php echo e(asset('KEPALA_SEKOLAH.pdf')); ?>" class="text-white text-decoration-none" download>
                <i class="bi bi-book-half"></i> Pedoman Teknis
              </a>
            </button>
            <a class="nav-link dropdown-toggle">
              <span class="font-weight-bold text-dark">
                <?php echo e(explode(' ', Auth::user()->name)[0]); ?> - 
                <span class="text-muted">
                  <?php echo e(Auth::user()->role === 'kepala_sekolah' ? 'ks' :
                    strtolower(substr(Auth::user()->role, 0, 1))); ?>

                </span>
              </span>
            </a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="icon-menu"></span>
        </button>
      </div>
    </nav>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_settings-panel.html -->
      <div class="theme-setting-wrapper">
        <div id="settings-trigger"><i class="ti-settings"></i></div>
        <div id="theme-settings" class="settings-panel">
          <i class="settings-close ti-close"></i>
          <p class="settings-heading">SIDEBAR SKINS</p>
          <div class="sidebar-bg-options selected" id="sidebar-light-theme"><div class="img-ss rounded-circle bg-light border mr-3"></div>Light</div>
          <div class="sidebar-bg-options" id="sidebar-dark-theme"><div class="img-ss rounded-circle bg-dark border mr-3"></div>Dark</div>
          <p class="settings-heading mt-2">HEADER SKINS</p>
          <div class="color-tiles mx-0 px-4">
            <div class="tiles success"></div>
            <div class="tiles warning"></div>
            <div class="tiles danger"></div>
            <div class="tiles info"></div>
            <div class="tiles dark"></div>
            <div class="tiles default"></div>
          </div>
        </div>
      </div>
      
      <!-- partial -->
      <!-- partial:partials/_sidebar.html -->
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('kepala_sekolah/index')); ?>">
              <i class="mdi mdi-home-variant"></i>
              <span class="menu-title ml-3">Beranda</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('kepala_sekolah/profil')); ?>">
              <i class="mdi mdi-account-box"></i>
              <span class="menu-title ml-3">Data Diri</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('kepala_sekolah/nilai-kelas')); ?>">
              <i class="mdi mdi-view-carousel"></i>
              <span class="menu-title ml-3">Nilai Kelas</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(url('kepala_sekolah/kehadiran')); ?>">
              <i class="mdi mdi-calendar-multiple-check"></i>
              <span class="menu-title ml-3">Kehadiran</span>
            </a>
          </li>
          <li class="nav-item">
  <a class="nav-link" href="#" onclick="confirmLogout(event)">
    <i class="mdi mdi-logout"></i>
    <span class="menu-title ml-3">Logout</span>
  </a>
  <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
    <?php echo csrf_field(); ?>
  </form>
</li>
        </ul>
      </nav>
      <div class="main-panel">
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <!-- <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2021.  Premium <a href="https://www.bootstrapdash.com/" target="_blank">Bootstrap admin template</a> from BootstrapDash. All rights reserved.</span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center">Hand-crafted & made with <i class="ti-heart text-danger ml-1"></i></span>
          </div>
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Distributed by <a href="https://www.themewagon.com/" target="_blank">Themewagon</a></span> 
          </div> -->
          <?php echo $__env->yieldContent('content'); ?>
        </footer>
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between mb-2">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">
              <strong>SILAKAN</strong> - <strong>SMP Negeri 6 Pekalongan</strong>
            </span> 
          </div>
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">
              Copyright © <?php echo e(date('Y')); ?>.
            </span>
          </div>
        </footer>  
        <!-- partial -->
      </div>
      <!-- partial -->
    </div>   
    <!-- page-body-wrapper ends -->
  
  <!-- Core JS -->
  <!-- jQuery first, then vendor bundle (incl. Bootstrap) -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="<?php echo e(asset('backend/vendors/js/vendor.bundle.base.js')); ?>"></script>

<style>
.swal2-popup.swal-popup-tall {
  height: 400px !important;
  display: flex !important;
  flex-direction: column !important;
  justify-content: center !important;
}
</style>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  function confirmLogout(event) {
    event.preventDefault();

    Swal.fire({
  title: 'Yakin ingin logout?',
  text: "Sesi kamu akan ditutup.",
  icon: 'warning',
  showCancelButton: true,
  confirmButtonColor: '#d33',
  cancelButtonColor: '#6c757d',
  confirmButtonText: 'Ya, logout',
  customClass: {
    popup: 'swal-popup-tall'
  }
}).then((result) => {
  if (result.isConfirmed) {
    document.getElementById('logout-form').submit();
  }
});

  }
</script>

  <!-- Page Plugin JS -->
  <script src="<?php echo e(asset('backend/vendors/chart.js/Chart.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/vendors/datatables.net/jquery.dataTables.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/vendors/datatables.net-bs4/dataTables.bootstrap4.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/dataTables.select.min.js')); ?>"></script>

  <!-- Injected JS -->
  <script src="<?php echo e(asset('backend/js/off-canvas.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/hoverable-collapse.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/template.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/settings.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/todolist.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/js/dashboard.js')); ?>"></script>

  <!-- Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

  <?php echo $__env->yieldPushContent('scripts'); ?>

</body>

</html>

<?php /**PATH C:\xampp\htdocs\silakan\resources\views/backend/layout/template_kepsek.blade.php ENDPATH**/ ?>