
<?php $__env->startSection('content'); ?>

<?php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
?>

<h4 class="mb-4">Selamat Datang di halaman kepala sekolah</h4>

<div class="alert alert-success shadow-sm mb-5">
  <h5><?php echo e($greeting); ?>, <?php echo e(Auth::user()->name); ?>!</h5>
  <p>Semangat menjalankan tugas hari ini!</p>
</div>

  <!-- LAYANAN KONSELING -->
  <div class="col-lg-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">
          <div class="mb-2">
            <small class="text-muted d-block text-center">Kelas dengan jumlah alpha terbanyak di bulan 
            <strong style="font-weight: bold;" class="text-danger">
  <?php echo e(\Carbon\Carbon::parse($latestBulan)->isoFormat('MMMM YYYY')); ?>

</strong>
          </div>
          <hr>
        </h4>
        <div class="table-responsive">
          <table class="table table-striped text-center">
            <thead>
              <tr>
                <th>Kelas</th>
                <th>Wali Kelas</th>
                <th>Total Alpha</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><?php echo e($top->kelas->nama); ?>

                - <?php echo e($top->kelas->tahunAjaran->tahun_awal); ?> / <?php echo e($top->kelas->tahunAjaran->tahun_akhir); ?></td>
                <td><?php echo e($top->kelas->waliKelas->name); ?></td>
                <td><?php echo e($top->total_alpha); ?></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<!-- SweetAlert -->
<script>
  <?php if(session('success')): ?>
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '<?php echo e(session('success')); ?>',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  <?php endif; ?>

  <?php if(session('error')): ?>
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '<?php echo e(session('error')); ?>',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  <?php endif; ?>

  <?php if(session('warning')): ?>
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '<?php echo e(session('warning')); ?>',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  <?php endif; ?>

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layout.template_kepsek', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\silakan\resources\views/backend/kepsek/index.blade.php ENDPATH**/ ?>