<h4 class="text-center" style="font-weight: bold;">Konfirmasi Perubahan Data</h4>
<hr class="">
<div class="row">
  <div class="col-md-6 form-group">
    <label>Data Berubah?</label>
    <select name="data_berubah" id="dataBerubahSelect" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Tidak','Ya'] as $db)
      <option value="{{ $db }}" {{ old('data_berubah', $siswa->data_berubah) == $db ? 'selected' : '' }}>{{ ucfirst($db) }}</option>
      @endforeach
    </select>
    <small class="form-text text-danger">* Khusus untuk kelas 7 pilih Tidak</small>
  </div>

  <div class="col-md-6 form-group" id="deskripsiField" style="display: none;">
    <label>Keterangan</label>
    <input type="text" name="deskripsi" value="{{ old('deskripsi', $siswa->deskripsi ?? '') }}" class="form-control" placeholder="Tulis data apa yang kamu ubah, contoh: pekerjaan_ayah, dll">
  </div>
</div>

<script>
  // toggle untuk Data Berubah / Deskripsi
  function toggleDeskripsiField() {
    const select = document.getElementById('dataBerubahSelect');
    const deskripsi = document.getElementById('deskripsiField');
    if (select.value === 'Ya') {
      deskripsi.style.display = 'block';
      // jika kamu ingin wajib isi ketika muncul:
      deskripsi.querySelector('input').setAttribute('required','');
    } else {
      deskripsi.style.display = 'none';
      deskripsi.querySelector('input').removeAttribute('required');
    }
  }

  // pas halaman load
  document.getElementById('dataBerubahSelect')
          .addEventListener('change', toggleDeskripsiField);
  window.addEventListener('DOMContentLoaded', toggleDeskripsiField);
</script>

