<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login | SILAKAN</title>
  <link rel="stylesheet" href="{{ asset('backend/vendors/mdi/css/materialdesignicons.min.css') }}">
  <link rel="stylesheet" href="{{ asset('backend/vendors/css/vendor.bundle.base.css') }}">
  <link rel="stylesheet" href="{{ asset('backend/css/vertical-layout-light/style.css') }}">
  <link rel="shortcut icon" href="{{ asset('backend/images/favicon.png') }}" />
  <style>
    body, html {
      height: 100%;
      background-color: #f7f9fc;
    }

    .auth-wrapper {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      padding: 1rem;
    }

    .auth-container {
      display: flex;
      width: 90%;
      max-width: 1000px;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.1);
      overflow: hidden;
    }

    .auth-left {
      padding: 3rem;
    }

    .auth-right {
      background: url('{{ asset('backend/images/login-banner.jpg') }}') no-repeat center center;
      background-size: cover;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .auth-right img {
      margin-top: 1rem;
      max-height: 250px;
      width: 100%;
      object-fit: contain;
    }

    .toggle-password {
      position: absolute;
      top: 50%;
      right: 1rem;
      transform: translateY(-50%);
      cursor: pointer;
    }

    /* Adjustments for small screens */
    @media(max-width: 767.98px){
      .auth-container {
        flex-direction: column;
      }

      .auth-right {
        height: 150px; /* Reduced height to bring logo closer */
        order: -1;
        background: none;
        padding-top: 1rem; /* Added padding to ensure logo isn't too close to top edge */
        padding-bottom: 0.5rem; /* Reduced padding at the bottom of the logo container */
      }
      .auth-right img {
        height: 100%;
      }

      /* Adjust margin for the "Selamat Datang" text */
      .auth-left .text-center {
        margin-top: -2rem !important; /* Reduce top margin */
        margin-bottom: 1rem !important; /* Reduce bottom margin */
      }
    }
  </style>
</head>
<body>

<div class="auth-wrapper">
  <div class="auth-container">
    <div class="row w-100 m-0">
      <div class="col-md-6 auth-right order-md-2">
        <img src="{{ asset('backend/images/logo-1.png') }}" alt="Logo">
      </div>

      <div class="col-md-6 auth-left order-md-1">
        <div class="text-center mb-4">
          <h4 class="mt-3">Selamat Datang</h4>
          <p class="text-muted">Silakan login untuk mengakses sistem</p>
        </div>

        <form action="{{ url('/login') }}" method="POST">
          @csrf
          <div class="form-group">
            <input type="text" name="email" class="form-control form-control-lg" placeholder="Id Pengguna" required>
          </div>

          <div class="form-group position-relative">
            <input type="password" name="password" id="password" class="form-control form-control-lg" placeholder="Password" required>
            <span id="togglePassword" class="toggle-password"><i class="mdi mdi-eye-off" id="eyeIcon"></i></span>
          </div>

          <div class="form-group">
            <select name="role" class="form-control form-control-lg text-dark" required>
              <option value="" hidden selected>Masuk sebagai</option>
              <option value="siswa">Siswa / Ortu</option>
              <option value="guru">Guru</option>
              <option value="guru_bk">Guru BK</option>
              <option value="kepala_sekolah">Kepala Sekolah</option>
              <option value="admin">Admin</option>
            </select>
          </div>

          <div class="d-grid mt-4">
            <button type="submit" class="btn btn-primary btn-lg btn-block">Login</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script src="{{ asset('backend/vendors/js/vendor.bundle.base.js') }}"></script>
<script src="{{ asset('backend/js/off-canvas.js') }}"></script>
<script src="{{ asset('backend/js/template.js') }}"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@if (session('error'))
<script>
  Swal.fire({
    icon: 'error',
    title: 'Login Gagal',
    text: '{{ session('error') }}',
    confirmButtonText: 'Coba Lagi',
    customClass: {
      popup: 'swal-popup-tall',
    }
  });
</script>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

@endif

<script>
  const togglePassword = document.getElementById('togglePassword');
  const passwordInput = document.getElementById('password');
  const eyeIcon = document.getElementById('eyeIcon');

  togglePassword.addEventListener('click', () => {
    const isPassword = passwordInput.type === 'password';
    passwordInput.type = isPassword ? 'text' : 'password';
    eyeIcon.classList.toggle('mdi-eye');
    eyeIcon.classList.toggle('mdi-eye-off');
  });
</script>

</body>
</html>