@extends('backend.layout.template_bk')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">DATA DIRI</h4>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
              <th>Nama</th>
              <th>Mengajar</th>
              <th>Nomor HP</th>
              <th>Email</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <tr class="text-center">
              <td>{{ $guru->user->name ?? '-' }}</td>
              <td>{{ $mapelBK->mapel->nama ?? '-' }}</td>
              <td>{{ $guru->no_hp ?? '-' }}</td>
              <td>{{ $guru->user->email ?? '-' }}</td>
              <td>
                <a href="#" class="btn btn-primary btn-sm text-white" title="Detail" data-toggle="modal" data-target="#detailGuruModal-{{ $guru->id }}">
                  <i class="bi bi-eye"></i>
                </a>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="detailGuruModal-{{ $guru->id }}" tabindex="-1" role="dialog" aria-labelledby="detailGuruModalLabel-{{ $guru->id }}" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="detailGuruModalLabel-{{ $guru->id }}">Detail Guru</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Tutup">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">

                    <div class="mb-3">
                        <label>Nama</label>
                        <input type="text" class="form-control" value="{{ $guru->user->name }}" disabled>
                    </div>
                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" class="form-control" value="{{ $guru->user->email }}" disabled>
                    </div>
                    <div class="mb-3">
                        <label>NIP</label>
                        <input type="text" class="form-control" value="{{ $guru->nip }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>Jenis Kelamin</label>
                        <input type="text" class="form-control" value="{{ $guru->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>No Handphone</label>
                        <input type="text" class="form-control" value="{{ $guru->no_hp }}" disabled>
                    </div>

            </div>

            <div class="modal-footer w-100">
                <div class="row w-100 d-flex justify-content-center">
                    <div class="col-12 col-lg-auto mb-2">
                        <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>



@endsection

