@extends('backend.layout.template_admin')

@section('content')

@php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
@endphp


<h3 style="margin-bottom: 30px">Selamat datang di halaman admin </h3>

<div class="alert alert-success shadow-sm mb-5">
  <h5>{{ $greeting }}, {{ Auth::user()->name }}!</h5>
  <p>Semangat menjalankan tugas hari ini!</p>
</div>

<div class="row text-center">
  <div class="col-sm-6 col-md-4 mb-4">
    <div class="card border-left-primary shadow-sm">
      <div class="card-body">
        <h6 class="text-primary mb-3">Jumlah Siswa Aktif</h6>
        <h2>{{ $siswaAktifCount }}</h2>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-md-4 mb-4">
    <div class="card border-left-success shadow-sm">
      <div class="card-body">
        <h6 class="text-primary">Jumlah Guru Mengajar</h6>
        <h2>{{ $guruCount }}</h2>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-md-4 mb-4">
    <div class="card border-left-info shadow-sm">
      <div class="card-body">
        <h6 class="text-primary">Jumlah Kelas</h6>
        <h2>{{ $kelasCount }}</h2>
      </div>
    </div>
  </div>
</div>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
@if (session('success'))
<script>
Swal.fire({
  icon: 'success',
  title: 'Login Berhasil!',
  html: 'Selamat datang di halaman admin!',
  confirmButtonText: 'Lanjutkan',
  customClass: { popup: 'swal-popup-tall' },
});
</script>
@endif

@endsection
