<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\TahunAjaran;
use Illuminate\Database\Eloquent\SoftDeletes;


class Semester extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'semesters';
    
    protected $fillable = ['semester', 'tahun_ajaran_id'];

    protected $dates = ['deleted_at'];

   public function tahunAjaran()
{
    return $this->belongsTo(TahunAjaran::class, 'tahun_ajaran_id')->withTrashed();
}

    public function kelas()
    {
        return $this->hasMany(Kelas::class);
    }
}
