<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;


class JadwalLayanan extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'jadwal_layanans';

    protected $fillable = [
        'guru_id', 'hari', 'jam',
    ]; 

     protected $dates = ['deleted_at'];

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'guru_id', 'guru_id')->with('user');
    }

    public function layanan()
    {
        return $this->hasMany(LayananKonseling::class);
    }
}

