@extends('backend.layout.template_bk')
@section('content')

<!-- Include CSS Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title w-100 w-lg-auto">RIWAYAT SEMUA DATA LAYANAN SISWA</h4>
      <div class="row mb-3 d-flex justify-content-between">
        <div class="col-12 col-sm-6 col-md-3 mb-2">
          <div class="dropdown w-100">
            <button class="btn btn-danger dropdown-toggle w-100" type="button" id="dropdownRoleFilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Pilih Tipe
            </button>
            <div class="dropdown-menu w-100" aria-labelledby="dropdownRoleFilter">
              <a class="dropdown-item {{ request('tipe') === null ? 'active' : '' }}"
                 href="{{ route('backend.bk.data_layanan_siswa') }}">Semua</a>
              <a class="dropdown-item {{ request('tipe') === '0' ? 'active' : '' }}"
                 href="{{ route('backend.bk.data_layanan_siswa', ['tipe' => 0]) }}">Konseling</a>
              <a class="dropdown-item {{ request('tipe') === '1' ? 'active' : '' }}"
                 href="{{ route('backend.bk.data_layanan_siswa', ['tipe' => 1]) }}">Parenting</a>
            </div>
          </div>
        </div>

        <div class="col-12 col-sm-6 col-md-3 mb-2">
          <form>
            <input id="search-input" class="form-control w-100" type="search"
                   placeholder="Cari NISN/Nama" aria-label="Search">
          </form>
        </div>
      </div>

      {{-- Tabel Riwayat Layanan --}}
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
              <th>No</th>
              <th>Tanggal</th>
              <th>Murid</th>
              <th>NISN</th>
              <th>Layanan</th>
              <th>Permasalahan</th>
              <th>Penyelesaian</th>
              <th>Hasil</th>
            </tr>
          </thead>
          <tbody>
            @forelse($layanans as $index => $layanan)
              <tr class="text-center">
                <td>{{ $index + 1 }}</td>
                <td class="tanggal">{{ \Carbon\Carbon::parse($layanan->tanggal)->translatedFormat('d F Y') }}</td>

                <td class="nama">{{ $layanan->siswa->name ?? '-' }}</td>

                <td class="nisn">{{ $layanan->siswa->siswa->nisn ?? '-' }}</td>

                <td>{{ $layanan->getTipeLabelAttribute() }}</td>

                <td>{{ $layanan->permasalahan }}</td>
                <td style="color: {{ $layanan->penyelesaian ? 'black' : '#dc3545' }}">
                  {{ $layanan->penyelesaian ?? 'Menunggu Jawaban' }}
                </td>
                <td style="color: {{ $layanan->hasil ? 'black' : '#dc3545' }}">
                  {{ $layanan->hasil ?? 'Menunggu Jawaban' }}
                </td>
              </tr>
            @empty
              <tr class="text-center">
                <td colspan="8">Belum ada data layanan.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Include JS Select2 -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
  $(document).ready(function () {
    $('.select2').each(function () {
      const modalParent = $(this).closest('.modal');
      $(this).select2({
        placeholder: "-- Pilih Siswa --",
        allowClear: true,
        width: '100%',
        dropdownParent: modalParent.length ? modalParent : $(document.body)
      });
    });
  });
</script>

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var nisn = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
            var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
            var combined = nisn + ' ' + nama;
            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

@endsection
