<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('layanans_konseling', function (Blueprint $table) {
            $table->id();
            $table->foreignId('jadwal_layanan_id')->constrained('jadwal_layanans')->onDelete('cascade');
            $table->foreignId('siswa_id')->constrained('users')->onDelete('cascade');
            $table->text('keterangan');
            $table->date('tanggal');
            $table->enum('status', ['Diproses', 'Disetujui', 'Ditolak', 'Selesai']);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('layanans_konseling');
    }
};
