<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('siswa', function (Blueprint $table) {
            $table->id();
            $table->foreignId('siswa_id')->constrained('users')->onDelete('cascade');
            $table->string('nisn')->unique()->nullable();
            $table->string('alamat')->nullable();
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->enum('jenis_kelamin', ['L','P'])->nullable();
            $table->string('agama')->nullable();
            $table->string('no_hp')->nullable();
            $table->string('no_telepon')->nullable();
            $table->string('sekolah_asal')->nullable();     
            $table->json('alamat_lengkap')->nullable();
            $table->json('data_ayah')->nullable();
            $table->json('data_ibu')->nullable();
            $table->json('data_wali')->nullable();
            $table->json('bantuan_sosial')->nullable();
            $table->json('data_rekening')->nullable();
            $table->json('data_fisik')->nullable();
            $table->string('lintang')->nullable();
            $table->string('bujur')->nullable();
            $table->string('jenis_tinggal')->nullable();
            $table->string('berkebutuhan_khusus', 100)->nullable();
            $table->string('anak_ke', 5)->nullable();
            $table->string('jumlah_saudara_kandung', 5)->nullable();
            $table->string('data_berubah')->nullable();
            $table->string('deskripsi')->nullable();
            $table->string('nipd')->nullable();
            $table->string('alat_transportasi')->nullable();
            $table->string('rombel_saat_ini')->nullable();
            $table->longText('dokumen_identitas')->nullable();
            $table->string('jarak_rumah')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('siswa');
    }
};

